/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.debug;

import java.util.Arrays;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.NonResumableException;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.Resumable;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugHook;
import org.squiddev.cobalt.function.Dispatch;

public final class DebugState {
    private static final int HOOK_CALL = 1;
    private static final int HOOK_RETURN = 2;
    private static final int HOOK_COUNT = 4;
    private static final int HOOK_LINE = 8;
    private static final int MAX_SIZE = 32768;
    private static final int MAX_ERROR_SIZE = 32778;
    private static final int MAX_JAVA_SIZE = 200;
    private static final int DEFAULT_SIZE = 8;
    private static final DebugFrame[] EMPTY = new DebugFrame[0];
    private final LuaState state;
    int top = -1;
    private int javaCount = 0;
    private DebugFrame[] stack = EMPTY;
    private DebugHook hook;
    private int hookMask;
    public boolean inhook;
    public int hookCount;
    public int hookPendingCount;

    public DebugState(LuaState state) {
        this.state = state;
    }

    public static DebugState get(LuaState state) {
        return state.getCurrentThread().getDebugState();
    }

    public DebugFrame pushJavaInfo() throws LuaError {
        int javaCount = this.javaCount + 1;
        if (javaCount >= 200) {
            throw new LuaError("stack overflow");
        }
        DebugFrame frame = this.pushInfo();
        frame.flags |= 1;
        this.javaCount = javaCount;
        return frame;
    }

    public DebugFrame pushInfo() throws LuaError {
        int top = this.top + 1;
        DebugFrame[] frames = this.stack;
        int length = frames.length;
        if (top >= length) {
            this.stack = DebugState.growStackOrOverflow(frames, top);
            frames = this.stack;
        }
        this.top = top;
        return frames[top];
    }

    private static DebugFrame[] growStackOrOverflow(DebugFrame[] frames, int top) throws LuaError {
        if (top >= 32768) {
            throw new LuaError("stack overflow");
        }
        int length = frames.length;
        return DebugState.growStack(frames, length == 0 ? 8 : Math.min(32768, length + length / 2));
    }

    private static DebugFrame[] growStack(DebugFrame[] frames, int newSize) {
        DebugFrame[] newFrames = new DebugFrame[newSize];
        System.arraycopy(frames, 0, newFrames, 0, frames.length);
        for (int i = frames.length; i < newSize; ++i) {
            newFrames[i] = new DebugFrame(i > 0 ? newFrames[i - 1] : null);
        }
        return newFrames;
    }

    public void growStackIfError() {
        DebugFrame[] stack = this.stack;
        if (this.top == Short.MAX_VALUE && stack.length == 32768) {
            this.stack = DebugState.growStack(stack, 32778);
        }
    }

    public void shrinkStackIfError() {
        DebugFrame[] stack = this.stack;
        int max = Math.min(Math.max(8, this.top) * 3, 32768);
        if (this.top < 32768 && stack.length > max) {
            this.stack = Arrays.copyOf(stack, Math.min(this.top * 2, 32768));
        }
    }

    public void popInfo() {
        DebugFrame frame = this.stack[this.top--];
        if ((frame.flags & 1) != 0) {
            --this.javaCount;
        }
        assert (this.javaCount >= 0);
        frame.clear();
    }

    public void setHook(DebugHook func, boolean call, boolean line, boolean rtrn, int count) {
        this.hook = func;
        this.hookMask = (call ? 1 : 0) | (line ? 8 : 0) | (rtrn ? 2 : 0) | (count > 0 ? 4 : 0);
        this.hookCount = count;
        this.hookPendingCount = count;
    }

    public DebugFrame getStack() {
        return this.top >= 0 ? this.stack[this.top] : null;
    }

    public DebugFrame getStackUnsafe() {
        return this.stack[this.top];
    }

    public DebugFrame getFrame(int level) {
        return level >= 0 && level <= this.top ? this.stack[this.top - level] : null;
    }

    public void onCall(DebugFrame frame) throws UnwindThrowable, LuaError {
        if ((this.hookMask & 1) == 0 || this.inhook) {
            return;
        }
        this.callHook(frame);
    }

    private void callHook(DebugFrame frame) throws LuaError, UnwindThrowable {
        this.inhook = true;
        frame.flags |= 0x400;
        try {
            this.hook.onCall(this.state, this, frame);
        }
        catch (Exception | VirtualMachineError e) {
            this.inhook = false;
            throw e;
        }
        this.inhook = false;
        frame.flags &= 0xFFFFFBFF;
    }

    public void onReturnNoHook() {
        this.popInfo();
        if ((this.hookMask & 8) != 0 && this.top >= 0) {
            DebugFrame returnInto = this.stack[this.top];
            returnInto.oldPc = returnInto.pc;
        }
    }

    public void onReturn(DebugFrame frame, Varargs result) throws LuaError, UnwindThrowable {
        if ((this.hookMask & 2) != 0 && !this.inhook) {
            this.returnHook(frame, result);
        }
        this.onReturnNoHook();
    }

    private void returnHook(DebugFrame frame, Varargs result) throws LuaError, UnwindThrowable {
        this.inhook = true;
        frame.flags |= 0x800;
        try {
            this.hook.onReturn(this.state, this, frame);
        }
        catch (UnwindThrowable e) {
            frame.extras = result;
            throw e;
        }
        catch (Exception | VirtualMachineError e) {
            this.inhook = false;
            throw e;
        }
        this.inhook = false;
        frame.flags &= 0xFFFFF7FF;
    }

    public void onInstruction(DebugFrame frame, int pc) throws LuaError, UnwindThrowable {
        if (this.inhook || (this.hookMask & 0xC) != 0) {
            this.onInstructionWorker(frame, pc);
        }
    }

    private void onInstructionWorker(DebugFrame frame, int pc) throws LuaError, UnwindThrowable {
        if (this.inhook) {
            if ((frame.flags & 0x3000) != 0) {
                this.inhook = false;
                frame.flags &= 0xFFFFCFFF;
            }
            return;
        }
        if ((this.hookMask & 0xC) == 0) {
            return;
        }
        this.hookInstruction(frame, pc);
        this.inhook = false;
        frame.flags &= 0xFFFFCFFF;
    }

    void hookInstruction(DebugFrame frame, int pc) throws LuaError, UnwindThrowable {
        if ((this.hookMask & 4) != 0 && (frame.flags & 0x1000) == 0 && --this.hookPendingCount == 0) {
            this.hookPendingCount = this.hookCount;
            this.inhook = true;
            frame.flags |= 0x1000;
            try {
                this.hook.onCount(this.state, this, frame);
            }
            catch (Exception | VirtualMachineError e) {
                this.inhook = false;
                throw e;
            }
        }
        if ((this.hookMask & 8) != 0 && (frame.flags & 0x2000) == 0) {
            Prototype prototype = frame.closure.getPrototype();
            int newLine = prototype.lineAt(pc);
            int oldPc = frame.oldPc;
            frame.flags |= 0x2000;
            if (pc <= oldPc || newLine != prototype.lineAt(oldPc)) {
                this.inhook = true;
                try {
                    this.hook.onLine(this.state, this, frame, newLine);
                }
                catch (Exception | VirtualMachineError e) {
                    this.inhook = false;
                    throw e;
                }
            }
        }
        frame.oldPc = pc;
    }

    public DebugHook getHook() {
        return this.hook;
    }

    public boolean hasCallHook() {
        return (this.hookMask & 1) != 0;
    }

    public boolean hasLineHook() {
        return (this.hookMask & 8) != 0;
    }

    public boolean hasReturnHook() {
        return (this.hookMask & 2) != 0;
    }

    public Varargs resume(DebugFrame frame, Varargs args) throws LuaError, UnwindThrowable {
        int flags = frame.flags;
        if ((flags & 0x3000) != 0) {
            this.hookInstruction(frame, frame.pc);
        }
        if ((flags & 0x400) != 0) {
            assert (this.inhook);
            this.inhook = false;
            frame.flags &= 0xFFFFFBFF;
            Varargs result = Dispatch.invokeFrame(this.state, frame);
            this.onReturn(frame, result);
            return result;
        }
        if ((flags & 0x800) != 0) {
            assert (this.inhook);
            this.inhook = false;
            frame.flags &= 0xFFFFF7FF;
            Varargs result = frame.extras;
            this.onReturnNoHook();
            return result;
        }
        if (!(frame.func instanceof Resumable)) {
            throw new NonResumableException(frame.func == null ? "null" : frame.func.debugName());
        }
        Varargs result = ((Resumable)((Object)frame.func)).resume(this.state, frame.state, args);
        this.onReturn(this.getStackUnsafe(), result);
        return result;
    }

    public Varargs resumeError(DebugFrame frame, LuaError error) throws LuaError, UnwindThrowable {
        if ((frame.flags & 0x3C00) != 0) {
            throw error;
        }
        if (!(frame.func instanceof Resumable)) {
            throw new NonResumableException(frame.func == null ? "null" : frame.func.debugName());
        }
        Varargs result = ((Resumable)((Object)frame.func)).resumeError(this.state, frame.state, error);
        this.onReturn(this.getStackUnsafe(), result);
        return result;
    }
}

